
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCashCollectionsTable extends Migration
{
    public function up()
    {
        Schema::create('cash_collections', function (Blueprint $table) {
            $table->bigIncrements('Cash_ID');

        
            $table->unsignedBigInteger('send_id')->nullable();
            $table->unsignedBigInteger('receive_id')->nullable();

            $table->decimal('amount', 10, 2);
            $table->tinyInteger('status')->default(0)->comment('0: Pending, 1: Completed, 2: Failed');

            $table->timestamps();

            $table->foreign('send_id')->references('U_Id')->on('user_masters')->onDelete('cascade');
            $table->foreign('receive_id')->references('U_Id')->on('user_masters')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('cash_collections');
    }
}
