<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BookEventController;
use App\Http\Controllers\CashCollectionController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CelebrationController;
use App\Http\Controllers\ComPackageController;
use App\Http\Controllers\CondolencesController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\UserMasterController;
use App\Http\Controllers\RoleMasterController;
use App\Http\Controllers\PackageFeatureController;
use App\Http\Controllers\PriceMasterController;
use App\Http\Controllers\DurationTypeController;
use App\Http\Controllers\DisValTypeController;
use App\Http\Controllers\ScheduleDemoController;
use App\Http\Controllers\PriceTypeValueController;
use App\Http\Controllers\DiscountMasterController;
use App\Http\Controllers\DiscountTypeController;
use App\Http\Controllers\DonateController;
use App\Http\Controllers\DonationController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\JobApplicationController;
use App\Http\Controllers\JobController;
use App\Http\Controllers\MarketplaceController;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\OtpController;
use App\Http\Controllers\PackageMasterController;
use App\Http\Controllers\TagController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::apiResource('roles', RoleMasterController::class);
Route::apiResource('users', UserMasterController::class);
Route::get('/deleted-users', [UserMasterController::class, 'getDeletedUsers']);
Route::post('/login', [LoginController::class, 'login']);
Route::apiResource('package-features', PackageFeatureController::class);
Route::apiResource('price-types', PriceMasterController::class);
Route::apiResource('duration-types', DurationTypeController::class);
Route::apiResource('dis-val-types', DisValTypeController::class);
Route::apiResource('schedule-demo', ScheduleDemoController::class);
Route::apiResource('price-type-values', PriceTypeValueController::class);
Route::apiResource('discount_types', DiscountTypeController::class);
Route::apiResource('discount-masters', DiscountMasterController::class);
Route::apiResource('packages', PackageMasterController::class);
Route::resource('tags', TagController::class);
Route::apiResource('notice', NoticeController::class);
Route::apiResource('gallary', GalleryController::class);
Route::apiResource('jobs', JobController::class);
Route::apiResource('com-packages', ComPackageController::class);
Route::apiResource('job-applications', JobApplicationController::class);
Route::apiResource('celebration', CelebrationController::class);
Route::delete('celebrations/{id}/image/{imageIndex}', [CelebrationController::class, 'deleteImage']);
Route::apiResource('condolences', CondolencesController::class);
Route::apiResource('marketplaces', MarketplaceController::class);
Route::get('marketplace/trashed', [MarketplaceController::class, 'trashed']);
Route::apiResource('events', EventController::class);
Route::get('deleted', [EventController::class, 'deleted']);
Route::apiResource('book-events', BookEventController::class);
Route::post('/send-otp', [OtpController::class, 'sendOtp']);
Route::post('/verify-otp', [OtpController::class, 'verifyOtp']);
Route::post('/reset-password', [OtpController::class, 'resetPassword']);
// categroy_route

Route::delete('/category/{id}',[CategoryController::class,'destroy']);
Route::put('/category/{id}',[CategoryController::class,'update']);
Route::get('/category/{id}',[CategoryController::class,'show']);
Route::post('/category',[CategoryController::class,'store']);
Route::get('/category',[CategoryController::class,'index']);

Route::delete('/CashCollection/{id}',[CashCollectionController::class,'destroy']);
Route::put('/CashCollection/{id}',[CashCollectionController::class,'update']);
Route::get('/CashCollection/{id}',[CashCollectionController::class,'show']);
Route::post('/CashCollection',[CashCollectionController::class,'store']);
Route::get('/CashCollection',[CashCollectionController::class,'index']);

Route::get('/donations', [DonationController::class, 'index']);
Route::get('/donations/{id}', [DonationController::class, 'show']);
Route::post('/donations', [DonationController::class, 'store']);
Route::put('/donations/{id}', [DonationController::class, 'update']);
Route::delete('/donations/{id}', [DonationController::class, 'destroy']);

Route::put('/donations/{id}/popup', [DonationController::class, 'triggerPopUp']);
// Route::put('/donations/{id}/activate', [DonationController::class, 'activate']);
// Route::put('/donations/{id}/deactivate', [DonationController::class, 'deactivate']);

Route::get('/donates', [DonateController::class, 'index']);
Route::get('/donates/{id}', [DonateController::class, 'show']);
Route::post('/donates', [DonateController::class, 'store']);
Route::put('/donates/{id}', [DonateController::class, 'update']);
Route::delete('/donates/{id}', [DonateController::class, 'destroy']);
